﻿using System;
using System.Collections.ObjectModel;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.ComponentModel;

using System.Linq;

namespace NUnitTestRunnerWP7.ViewModels
{
    public class ResultsListViewModel :INotifyPropertyChanged
    {
        public ResultsListViewModel()
        {
            // Loading Sample Data
            if (DesignerProperties.IsInDesignTool)
            {
                

                this.Items.Add(new UnitTestResultViewModel());
                this.Items.Add(new UnitTestResultViewModel
                                   {
                                       ClassName = "SampleClass",
                                       ElapsedMilliseconds = 1000,
                                       ErrorMessage = "Sample Error Message",
                                       MethodName = "SampleMethod2",
                                       Result = TestResult.Failed
                                   });
                this.Items.Add(new UnitTestResultViewModel
                                   {
                                       ClassName = "SampleClass2",
                                       ElapsedMilliseconds = 0,
                                       ErrorMessage = "",
                                       MethodName = "SampleMethod1",
                                       Result = TestResult.Ignored

                                   });
                this.Items.Add(new UnitTestResultViewModel
                                   {
                                       ClassName = "SampleClass2",
                                       ElapsedMilliseconds = 50,
                                       ErrorMessage = "",
                                       MethodName = "SampleMethod2",
                                       Result = TestResult.Passed

                                   });
                this.Items.Add(new UnitTestResultViewModel
                                   {
                                       ClassName = "SampleClass2",
                                       ElapsedMilliseconds = 65,
                                       ErrorMessage = "",
                                       MethodName = "SampleMethod",
                                       Result = TestResult.Passed

                                   });
                this.Items.Add(new UnitTestResultViewModel
                                   {
                                       ClassName = "SampleClass3",
                                       ElapsedMilliseconds = 5000,
                                       ErrorMessage = "Sample Error Message",
                                       MethodName = "SampleMethod0",
                                       Result = TestResult.Failed
                                   });
                this.Items.Add(new UnitTestResultViewModel
                {
                    ClassName = "SampleClass3",
                    ElapsedMilliseconds = 0,
                    MethodName = "SampleMethod5",
                    Result = TestResult.Ignored
                });

            }
        }

        private static ResultsListViewModel intance;
        public static ResultsListViewModel Intance
        {
            get
            {
                if (intance == null)
                    intance = new ResultsListViewModel();
                return intance;
            }
        }

        private ObservableCollection<UnitTestResultViewModel> items = new ObservableCollection<UnitTestResultViewModel>();
        public ObservableCollection<UnitTestResultViewModel> Items
        {
            get
            {
                return items;
            }
        }

        public int FailedCount
        {
            get
            {
                return Items.Count(i => i.Result == TestResult.Failed);
            }
        }

        public int PassedCount
        {
            get
            {
                return Items.Count(i => i.Result == TestResult.Passed);
            }
        }

        public int IgnoredCount
        {
            get
            {
                return Items.Count(i => i.Result == TestResult.Ignored);
            }
        }

        public int TotalCount
        {
            get
            {
                return Items.Count();
            }
        }

        public int TotalMilliseconds
        {
            get
            {
                return Items.Sum(i => i.ElapsedMilliseconds);
            }
        }
        #region INotifyPropertyChanged Members

        public event PropertyChangedEventHandler PropertyChanged;
        protected void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        #endregion
    }
}
